/* @(#) $Id$ (LBL) */
#ifndef acld_cf_h
#define acld_cf_h

#include "acl.h"

/* Validate unsigned 16 bit value */
#define VALID_PORT(p) ((p) > 0 && (p) <= 0xFFFF)

/* True if the sequence number is in the HOST range (and we have a range) */
#define IN_SEQRANGE(n) \
    (cf->c_lowseq == cf->c_highseq || \
    ((n) >= cf->c_lowseq && (n) <= cf->c_highseq))

/* True if the sequence number is in the HOSTPORT range (and we have a range) */
#define IN_PERMITHOSTPORTSEQRANGE(n) \
    (cf->c_lowpermithostportseq == cf->c_highpermithostportseq || \
    ((n) >= cf->c_lowpermithostportseq && (n) <= cf->c_highpermithostportseq))

/* True if the sequence number is in the PORT range (and we have a range) */
#define IN_PORTSEQRANGE(n) \
    (cf->c_lowportseq == cf->c_highportseq || \
    ((n) >= cf->c_lowportseq && (n) <= cf->c_highportseq))

#ifdef HAVE_CORSA
/* Corsa per server config */
struct corsa {
	// int n;				/* starts a 1 */
	char saddr[40];			/* corsa server address */
	char tokenfn[255];		/* corsa token filename */
	char token[255];		/* corsa token */
};
#endif

struct cf {
	time_t c_time;			/* unix timestamp of config file */
	int c_port;			/* local port to listen for clients */
	int c_portro;			/* read only clients */
	int c_portweb;			/* web registration clients */
	int c_login_secs;		/* child secs between login attempts */
	int c_login_secs2;		/* child2 secs between login attempts */
	int c_ayt_secs;			/* child secs before ayt keep alive */
	int c_ayt_secs2;		/* child2 secs before ayt keep alive */
	int c_sync_secs;		/* seconds to wait before sync'ing */
	int c_select_secs;		/* default seconds in select loop */
	int c_incrseq;			/* increment or decrement seq numbers */
	int c_netsfac;			/* syslog() facility for nets_log() */

	int c_lowseq;			/* lowest sequence number */
	int c_highseq;			/* highest sequence number */
	int c_maxseq;			/* maximum total number of rules */

	int c_lowportseq;		/* lowest port sequence number */
	int c_highportseq;		/* highest port sequence number */

	int c_lowpermithostportseq;	/* lowest host/port sequence number */
	int c_highpermithostportseq;	/* highest host/port sequence number */

	int c_nullzeromax;		/* maximum total number of nullzero's */

	int c_retries;			/* maximum number of retries */

	struct addr c_bindaddr;		/* local IPv4 addr to bind to */
	struct addr c_bindaddr6;	/* local IPv6 addr to bind to */
	int c_listen6;			/* listen for IPv6 connections */

	int c_ipv4_maxwidth;		/* widest IPv4 acl block */
	int c_ipv6_maxwidth;		/* widest IPv6 acl block */

	int c_ipv4_maxnullzerowidth;	/* widest IPv4 nullzero route */
	int c_ipv6_maxnullzerowidth;	/* widest IPv6 nullzero route */

	char *c_cuser;			/* connect username */
	char *c_cpass1;			/* primary connect password */
	char *c_cpass2;			/* backup connect password */

	char *c_euser;			/* enable username */
	char *c_epass1;			/* primary enable password */
	char *c_epass2;			/* backup enable password */

#ifdef __FreeBSD__
	int c_freebsdroutes;		/* use FreeBSD nullzero routes */
	char *c_nullzeroif;		/* null zero interface name */
	struct addr c_nullzeroaddr;	/* nullzero IPv4 address */
	struct addr c_nullzeroaddr6;	/* nullzero IPv6 address */
#endif

#ifdef HAVE_JUNOSCRIPT
	int c_junoscript;		/* using junoscript */
	int c_portssh;			/* ssh connect port */
	char *c_sshkeyfn;		/* ssh key filename */
	char *c_sshpubfn;		/* ssh pub filename */
	char *c_junoscriptlog;		/* debug log filename */
#endif

#ifdef HAVE_CORSA
	int c_corsa;			/* using corsa */
	struct corsa *c_corsaservers;	/* per server config */
	struct array c_corsaservers_array;
	char *c_corsacacert;		/* corsa rootca */
	char *c_corsalog;		/* debug log filename */
	struct addr *c_corsalocalnets;	/* corsa local networks */
	struct array c_corsalocalnets_array;
#endif

	int c_mockclient;		/* test without touching network */

	char *c_expect;			/* pathname expect binary */
	char *c_expectlog;		/* debug log filename */
	char *c_router;			/* ip addr or hostname of router */
	char *c_script;			/* pathname expect binary */
	char *c_id;			/* optional NETS log id */
	char *c_device;			/* optional NETS log device */

#ifdef HAVE_CFORCE
	char *c_cforceaddr;		/* cForce device ip addr or hostname */
	char *c_cforcedata;		/* cForce saved data file location */
	int c_portcforce;		/* cForce device port */
#endif

	struct acllimit *c_acllimit;
	struct array c_acllimit_array;

	struct aclgroup *c_aclgroup;
	struct array c_aclgroup_array;

	struct intlist *c_intlist;
	struct array c_intlist_array;

	struct aroute *c_nullzeronets;
	struct array c_nullzeronets_array;

	char **c_prefixes;
	struct array c_prefixes_array;

	char *c_macwhitelistfn;
	struct mac *c_macwhitelist;
	struct array c_macwhitelist_array;

	char *c_whitelistfn;
	struct addr *c_whitelist;
	struct array c_whitelist_array;

	struct addr c_replicantaddr;	/* IP address of replicant acld */
	int c_replicant_session_secs;	/* time to wait for replcant request */
	int c_portreplicant;		/* replicant acld's connect port */
	int c_replicate_acl;		/* replicate ACLs */
	int c_replicate_macwhitelist;	/* replicate mac whitelist */
	int c_replicate_nullzero;	/* replicate nullzero routes */
	int c_replicate_prefix;		/* replicate prefix lists */
	int c_replicate_whitelist;	/* replicate whitelist */
	int c_replicate_primary;	/* we are the primary acld */
};

extern struct cf *cf;

extern void freecf(void);
extern void intlistadd(const char *);
extern void parsecf(const char *);
#endif
