/* @(#) $Id$ (LBL) */
#ifndef acld_child2_h
#define acld_child2_h

/* The child can be in other states and still be logged in */
#define CHILD2LOGGEDIN(s) ((s) == ASTATE_LOGGEDIN || (s) == ASTATE_READRESPONSE)

/* Child pointer to outstanding2 bit */
#define CHILD2BIT(p) (1 << ((p)->n))

/* Has this child processed this request? */
#define CHILD2DONE(cp, rp) ((CHILD2BIT(cp) & (rp)->child2notdone) == 0)

extern void child2connect(fd_set *, fd_set *);
extern void child2freereq(struct req *);
extern void child2input(void);
extern void child2poll(fd_set *, fd_set *);
extern int child2ready(void);
extern void child2reload(void);
extern int child2retry(struct child *, struct client *, struct req *,
    const char *);
extern void child2clientsend(struct child *, struct client *, struct req *);
extern void child2clientsenderr(struct child *, struct client *, struct req *,
    const char *, ...)
    __attribute__ ((format (printf, 4, 5)));
extern void child2clientsendfmt(struct child *, struct client *, struct req *,
    const char *, ...) __attribute__ ((format (printf, 4, 5)));
extern void child2setastate(struct child *, enum acldstate);
extern int child2settimeout(int);
extern void child2state(struct req *);
extern int child2update_fd_set(fd_set *, fd_set *, int);
extern int child2watchdog(void);
#endif
