/* @(#) $Id$ (LBL) */
#ifndef acld_client_h
#define acld_client_h

#include "io.h"

enum clienttype {
	CTYPE_PRIV = 0,			/* unlimited */
	CTYPE_RO,			/* read/only */
	CTYPE_WEB			/* permittcpdsthostport */
};

struct client {
	struct client *next;
	u_int n;			/* client number */
	int c;				/* client socket */
	struct addr addr;		/* client ip address */
	enum clienttype type;
	time_t connect_ts;		/* connection timestamp */
	int close;			/* finish writing and then close */
	int replicant;			/* client is a replicant */
	struct iobuf rbuf;		/* read buffer */
	struct iobuf wbuf;		/* write buffer */
	struct req *treq;		/* partially built request */
	struct req *req;		/* request list */
	struct req *hreq;		/* handleclientreqs() temp req list */
};

extern struct s2v cmd2req[];
extern struct s2v ctype2str[];

extern void clientcompact(struct client *, struct req *);
extern void clientdroprestore(struct client *, struct req *);
extern void clientfinishreq(struct client *, struct req *);
extern void clientinput(struct client *);
extern void clientlistroute(struct client *, struct req *, int);
extern void clientnullzero(struct client *, struct req *);
extern void clientprefix(struct client *, struct req *);
extern void clientprocess(struct client *, struct req *, int);
extern void clientquerynullzero(struct client *, struct req *);
extern void clientsend(struct client *, struct req *);
extern void clientsendall(void);
extern void clientsenderr(struct client *, struct req *, const char *, ...)
    __attribute__ ((format (printf, 3, 4)));
extern void clientsendallerr(const char *, ...)
    __attribute__ ((format (printf, 1, 2)));
extern void clientsendfmt(struct client *, struct req *, const char *, ...)
    __attribute__ ((format (printf, 3, 4)));
extern void freeclient(struct client *);
extern struct client *newclient(int);
#endif
