#!/bin/sh
# @(#) $Id$ (LBL)

prog=`basename $0`

usage()
{
	echo "usage: ${prog} [-wtd] FILE ..." 1>&2
	exit 1
}

filter()
{
	awk '
	BEGIN {
		skip_n_acl_h["stats"] = 1
		skip_n_acl_h["mac"] = 1
		skip_n_acld_h["acl"] = 1
		skip_n_acld_h["req"] = 2
		skip_n_acld_h["rereq"] = 1
		skip_n_acld_h["state"] = 1
	}
	$1 ~ /^(addr|cf|state)$/ && $2 !~ /\.h$/ {
		# Skip any of these when not in an include
		next
	}
	$2 == "acl.h" {
		# Skip the first N occurances
		if (skip_n_acl_h[$1] > 0) {
			--skip_n_acl_h[$1]
			next
		}
	}
	$2 == "acld.h" {
		# Skip the first N occurances
		if (skip_n_acld_h[$1] > 0) {
			--skip_n_acld_h[$1]
			next
		}
	}
	{
		print
	}
	'
}

flags=""

while getopts wtd opt ; do
	case "$opt" in

        d)
		flags="${flags}d"
                ;;

        t)
		flags="${flags}t"
                ;;

        w)
		flags="${flags}w"
                ;;

	?)
		usage
		;;
	esac
done

shift $((${OPTIND} - 1))

if [ $# -eq 0 ]; then
        usage
fi

if [ -n "${flags}" ]; then
	flags="-${flags}"
fi

t1="`mktemp /tmp/${prog}.XXXXXX`"

chmod +r ${t1}

trap 'rm -f tags ${t1}; exit 1' 1 2 3 15

ctags ${flags} "$@"
mv tags ${t1}
filter < ${t1} > tags
rm ${t1}
