/*
 * Copyright (c) 1995, 1997, 2013
 * The Regents of the University of California. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University nor the names of its contributors
 *       may be used to endorse or promote products derived from this software
 *       without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#if defined(LIBC_SCCS) && !defined(lint)
static const char sccsid[] = "@(#)daemon.c	5.3 (Berkeley) 12/28/90";
#endif /* LIBC_SCCS and not lint */

#include <sys/param.h>		/* optionally get BSD define */
#ifdef HAVE_FILE_H
#include <sys/file.h>
#endif
#include <sys/ioctl.h>

#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif
#include <unistd.h>

#ifdef HAVE_PATHS_H
#include <paths.h>
#else
#define _PATH_TTY "/dev/tty"
#define _PATH_DEVNULL "/dev/null"
#endif

#ifndef  STDIN_FILENO
#define  STDIN_FILENO	0	/* standard input file descriptor */
#define STDOUT_FILENO	1	/* standard output file descriptor */
#define STDERR_FILENO	2	/* standard error file descriptor */
#endif

int
daemon(nochdir, noclose)
	int nochdir, noclose;
{
	int cpid;
#ifndef HAVE_SETSID
	int t;
#endif

	if ((cpid = fork()) == -1)
		return (-1);
	if (cpid)
		exit(0);
#ifdef HAVE_SETSID
	(void) setsid();
#else
	(void) setpgrp(0, getpid());
	t = open(_PATH_TTY, O_RDWR);
	if (t >= 0) {
		(void) ioctl(t, TIOCNOTTY, 0);
		(void) close(t);
	}
#endif
	if (!nochdir)
		(void) chdir("/");
	if (!noclose) {
		int devnull = open(_PATH_DEVNULL, O_RDWR, 0);

		if (devnull != -1) {
			(void) dup2(devnull, STDIN_FILENO);
			(void) dup2(devnull, STDOUT_FILENO);
			(void) dup2(devnull, STDERR_FILENO);
			if (devnull > 2)
				(void) close(devnull);
		}
	}
	return(0);
}
