/*
 * Copyright (c) 2020, 2021
 * The Regents of the University of California. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University nor the names of its contributors
 *       may be used to endorse or promote products derived from this software
 *       without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char rcsid[] __attribute__ ((unused)) =
    "@(#) $Id$ (LBL)";
#endif

#include <sys/types.h>
#include <sys/time.h>

#include <arpa/inet.h>

#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sysexits.h>
#include <unistd.h>

#include "acld.h"
#include "history.h"

#define DELTA_SECS 2

#ifndef HISTORYNUM
#define HISTORYNUM 1024
#endif

/* Locals */
static struct history history[HISTORYNUM];
static struct history *historyp;

#define NEXTH(p) ((p) >= (history + HISTORYNUM - 1) ? history : (p) + 1)
#define PREVH(p) ((p) == history ? history + HISTORYNUM - 1 : (p) - 1)

void
history_add(struct addr *a, enum reqtype type, struct timeval *tvp)
{
	historyp = NEXTH(historyp);
	historyp->type = type;
	historyp->tv = *tvp;
	historyp->ip = *a;
}

struct timeval *
history_find(struct addr *a, enum reqtype type)
{
	int i;
	struct history *hp;

	for (i = 0, hp = historyp; i < HISTORYNUM; ++i, hp = PREVH(hp)) {
		if (hp->type == 0)
			break;
		if (hp->type != type)
			continue;
		if (ITEMEQ(&hp->ip, a))
			return (&hp->tv);
	}

	return (NULL);
}

void
history_init(void)
{
	historyp = history;
}
