/* @(#) $Id$ (LBL) */
#ifndef acld_io_h
#define acld_io_h

#include <stdarg.h>

#include "util.h"

/* I/O buffer */
struct iobuf {
	char *buf;
	struct array io_array;
};

#define IOBUF_OSIZE(ip) ((ip)->io_array.osize)
#define IOBUF_INCLEN(ip) ((ip)->io_array.inclen)
#define IOBUF_LEN(ip) ((ip)->io_array.len)
#define IOBUF_SIZE(ip) ((ip)->io_array.size)

#define IOBUF_BYTES 8192

#define IOBUF_INIT(ip) \
    ((ip)->io_array.osize = 1, (ip)->io_array.inclen = IOBUF_BYTES)

extern void ioappendbuf(struct iobuf *, const char *);
extern void ioappendfmt(struct iobuf *, const char *, ...)
    __attribute__ ((format (printf, 2, 3)));
extern void ioappendline(struct iobuf *, const char *);
extern void ioappendvfmt(struct iobuf *, const char *, va_list);
extern void ioinsertline(struct iobuf *, const char *);
extern int iocomment(char **, struct iobuf *);
extern int ioconsolidate(struct iobuf *);
#ifdef HAVE_JUNOSCRIPT
extern void ioeat(struct iobuf *, size_t);
#endif
extern void iofree(struct iobuf *);
extern char *iogetstr(struct iobuf *);
extern int iohaveline(struct iobuf *);
#ifdef HAVE_JUNOSCRIPT
extern int iohaverpcreply(struct iobuf *);
#endif
extern int ioread(int, struct iobuf *);
extern int iowrite(int, struct iobuf *);
#endif
