/* @(#) $Id$ (LBL) */
#ifndef acld_jreq_h
#define acld_jreq_h

#include "acl.h"

enum jreqtype {
	JREQ_UNKNOWN = 0,
	JREQ_PREFIX,
	JREQ_MACFILTER,		/* mac address filter */
};

struct jrequest {
	enum reqtype type;	/* REQ_* */
	enum jreqtype jtype;	/* JREQ_* */
	int dofirewall;		/* add firewall filter config */
	int doremoveterm;	/* remove firewall term */
	char proto[32];		/* tcp or udp */
	char protokey[32];	/* protocol, payload-protocol or next-header */
	char family[32];	/* inet or inet6 */
	char addr[128];
	char port[32];
	char seq[32];
	struct mac mac;
	char filter[64];	/* e.g. ACLD-HOSTPORT */
	char prefix[64];	/* e.g. ACLD-TCP-HOSTPORT53 */
};

extern const char *jreq_add(struct jrequest *);
extern void jreq_cleanup(void);
extern int jreq_dirty(void);
extern void jreq_init(void);
extern const char *jreq_render(const char **);
#endif
