/*
 * Copyright (c) 2020, 2022, 2024
 * The Regents of the University of California. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University nor the names of its contributors
 *       may be used to endorse or promote products derived from this software
 *       without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char rcsid[] __attribute__ ((unused)) =
	"@(#) $Id$ (LBL)";
#endif

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>

#include "acld.h"
#include "util.h"

#include "mock_client.h"

/* Forwards */
static void mock_childlistroute(void);
void mock_listroute(struct client *cl, struct req *rp,
	int nullzeroonly);
void mock_routes(struct client *cl, struct req *rp);

static void
mock_childlistroute(void)
{
	lg(LOG_INFO, "mock_childlistroute");
	/* Count the number of nullzero routes */
	mock_listroute(NULL, NULL, 1);
	++state.listedroutes;
}

void
mock_listroute(struct client *cl, struct req *rp,
	int nullzeroonly)
{
	lg(LOG_INFO, "mock_listroute");
	/* (re)count the number of nullzero routes as a side effect */
	state.nullzerolen = 0;
}

void
mock_routes(struct client *cl, struct req *rp)
{
	struct addr *a;
	char buf[1024];
	char *errmsg = NULL;

	/* Log for NETS */
	nets_log(cl, rp);

	/* RTA_DST */
	a = &rp->nullzero.dst;
	lg(LOG_INFO, "mock_routes: type=%d, addr=%s", rp->type, addr2str(a));

	switch (rp->type) {

	case REQ_NULLZERO:
		break;

	case REQ_NONULLZERO:
		break;

	case REQ_QUERYNULLZERO:
		snprintf(buf, sizeof(buf), "%s not found", addr2str(a));
		errmsg = buf;
		break;

	default:
		lg(LOG_ERR, "route_cmd: unknown type %s",
			val2str(cmd2req, rp->type));
		abort();
	}

	if (errmsg != NULL)
		clientsenderr(cl, rp, "%s", errmsg);
	else
		clientsend(cl, rp);
}

void
mock_init(void)
{
	struct state *sp;

	sp = &state;
	lg(LOG_INFO, "mock_init");

	/* Child hooks */
	sp->f_childlistroute = mock_childlistroute;

	/* Client hooks */
	sp->f_clientlistroute = mock_listroute;
	sp->f_clientnullzero = mock_routes;
	sp->f_clientquerynullzero = mock_routes;

}
