/* @(#) $Id$ (LBL) */
#ifndef acld_replicant_h
#define acld_replicant_h

/* Replicant request states */
enum rereqstate {
	RESTATE_PENDING = 0,	/* not processed yet */
	RESTATE_REPLICANT,	/* waiting for replicant to reply */
	RESTATE_READRESPONSE,	/* reading replicant response */
	RESTATE_DONE		/* ok to remove from queue */
};

/* Request flags */
enum rereqflags {
	REFLAG_FAILED	= 0x2,	/* request resulted in a failed status */
	REFLAG_IGNORE	= 0x4,	/* request didn't result in any changes */
};

/* Replicant request */
struct rereq {
	struct rereq *next;
	struct req *req;		/* link to client request */
	enum reqtype type;		/* REQ_* */
	enum rereqstate state;		/* RESTATE_* */
	enum rereqflags reflags;	/* replicant request flags */
	int retries;
	struct timeval cts;		/* completion timestamp */
	const char *cmd;		/* command name */
	char *aclname;			/* listacl, compact, drop udp/tcp ACL */
	char *prefixname;		/* prefix, noprefix and listprefix */
	u_int32_t cookie;
	char *comment;			/* comment sent to replicant */
	char *response;			/* response received from replicant */
	struct aroute nullzero;
	struct addr prefix;
	struct addr whitelist;
	struct acl acl;
};

extern void replicantappendreq(struct rereq *, struct rereq **);
extern void replicantbump(void);
extern void replicantdone(struct rereq *);
extern void replicantfreerereq(struct rereq *);
extern void replicantinit(void);
extern void replicantinput(void);
extern void replicantlogin(void);
extern void replicantprocess(void);
extern void replicantreqhook(struct req *);
extern void replicantsend(struct rereq *);
extern void replicantterminate(const char *);
extern void replicantwrite(const char *, ...);
#endif
