/* @(#) $Id$ (LBL) */
#ifndef acld_route_h
#define acld_route_h

/* ACLD route types */
enum aroutetype {
	ROUTE_UNKNOWN = 0,
	ROUTE_STATIC,
	ROUTE_DYNAMIC,
	ROUTE_INTERFACE,
	ROUTE_NULLZERO
};

/* ACLD route */
struct aroute {
	enum aroutetype type;
	struct addr dst;
	struct addr gw;
	char *raw;			/* text as returned from the router */
};

extern struct s2v str2route[];

extern int goodnullzero(struct addr *);
extern int nullzeronetadd(const char *);
extern void routeadd(struct aroute *);
extern int routedelete(struct aroute *);
extern struct aroute *routefind(struct aroute *);
extern const char *routeformat(struct aroute *);
extern void routefree(void);
extern void routeinit(void);
extern void routelistsfree(void);
extern int routestradd(const char *);
#endif
