/* @(#) $Id$ (LBL) */
#ifndef acld_rpc_h
#define acld_rpc_h

#include <libxml/parser.h>
#include <libxml/tree.h>

struct rpcresult {
	int enginecommitsuccess;
	int engineignored;
	int commitsuccess;
	int loadsuccess;
	int loaderror;
	char errmsg[128];
};

#define ISXMLTAG(s, t) \
    (strncmp((s), (t), sizeof(t) - 1) == 0)

#define ISXMLCOMMENT(s) \
    ISXMLTAG(s, xml_comment)

#define ISXML_ELEMENT(p) \
    ((p) != NULL && (p)->type == XML_ELEMENT_NODE && (p)->name != NULL)

#define ISXML_ELEMENT_NAMED(p, s) \
    (ISXML_ELEMENT(p) && strcmp((const char *)((p)->name), (s)) == 0)

#define ISXML_TEXT(p) \
    ((p) != NULL && (p)->content != NULL && (p)->type == XML_TEXT_NODE)

extern const char acldprefix[];

extern void rpc_cleanup(xmlDocPtr);
extern struct rpcresult *rpc_process(xmlNode *);
#ifdef notdef
extern void rpc_prefix_dump(void);
#endif
#endif
