/* @(#) $Id$ (LBL) */
#ifndef acld_stats_h
#define acld_stats_h

struct bucket {
	int count;
	int hiwater;
};

struct stats {
	struct bucket *cur;
	struct bucket *buckets;
	size_t len;
	int secs;
	int lastvalue;
	long lasttime;
};

extern void stats_free(struct stats *);
extern int stats_gethiwater(struct stats *);
extern int stats_getrate(struct stats *, const char *);
extern void stats_init(struct stats *, size_t, int, const char *);
extern void stats_sethiwater(struct stats *, int);
extern void stats_setrate(struct stats *);
extern void stats_setvalue(struct stats *, int);
#endif
