/*
 * https://gist.github.com/scintill/f332033cf0bd27a0fe693ccd162b61a2
 * cc -fPIC -shared test-syslog.c -o test-syslog.so
 * LD_PRELOAD=./test-syslog.so ./acld ...
 */

#define _GNU_SOURCE
#include <stdio.h>
#include <syslog.h>
#include <dlfcn.h>
#include <stdarg.h>

void
syslog(int pri, const char *fmt, ...)
{
	va_list ap;
	printf("syslog: ");
	va_start(ap, fmt);
	vprintf(fmt, ap);
	va_end(ap);
	putc('\n', stdout);
}

void
vsyslog(int pri, const char *fmt, va_list ap)
{
	printf("syslog: ");
	vprintf(fmt, ap);
	putc('\n', stdout);
}
