#!/bin/sh
# @(#) $Id$ (LBL)

set -eEuo pipefail

# XXX
PYTHONPATH=${PWD}/.env/lib/python3.7/site-packages
export PYTHONPATH

# run 1 test

# set up area
rm -f test2-acld.out*
rm -rf testinstall/log/acld testinstall/db/acld testinstall/run/acld
mkdir -p testinstall/log/acld testinstall/db/acld testinstall/run/acld

echo "Starting acld"
LD_PRELOAD=`dirname $0`/test-syslog.so ./acld -d -f -o testinstall/log/acld/acld.log -P testinstall/run/acld/acld.pid -c ../testconfig.cfg > test2-acld.out &
acld_pid=$!

sleep 5
. .env/bin/activate

echo "Running acl-script"
acl-script \
    -U testuser \
    -H testhost.lbl.gov \
    -p 11965 \
    -F ../test-acl-script.conf \
    -c 'a comment' nullzero < ../test-input-nullzero1.txt

sleep 5
kill ${acld_pid}

grep 'syslog: NETS' test2-acld.out > test2-acld.out.filtered
sed -E -e 's/ats=[0-9]+\.[0-9]+/ats=TSTAMP/' \
    -e 's/cts=[0-9]+\.[0-9]+/cts=TSTAMP/' \
    < test2-acld.out.filtered > test2-acld.out.filtered2

diff test2-acld.out.filtered2 ../test2-acld-expected.out
