/*
 * Copyright (c) 2002, 2006, 2008, 2013, 2016, 2020
 * The Regents of the University of California. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University nor the names of its contributors
 *       may be used to endorse or promote products derived from this software
 *       without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char rcsid[] __attribute__ ((unused)) =
    "@(#) $Id$ (LBL)";
#endif

#include <sys/types.h>
#include <sys/time.h>

#include <stdio.h>

#include "acld.h"

/* Return seconds left (or -1 if not pending) */
int
timercheck(struct timer *tp)
{
	int i;
	struct timeval tv;

	if (tp->duetime == 0)
		return (-1);
	getts(&tv);
	i = tp->duetime - tv.tv_sec;
	if (i < 0)
		i = 0;
	return (i);
}

int
timerdue(struct timer *tp)
{

	if (timercheck(tp) != 0)
		return (0);
	timerreset(tp);
	return (1);
}

void
timerreset(struct timer *tp)
{

	tp->duetime = 0;
}

void
timerset(struct timer *tp, int secs)
{
	struct timeval tv;

	getts(&tv);
	tp->duetime = tv.tv_sec + secs;
	/* Insure at least 500 ms delay */
	if (secs == 1 && tv.tv_usec < 500000)
		++tp->duetime;
}
