/* @(#) $Id$ (LBL) */
#ifndef acld_util_h
#define acld_util_h

#include <sys/stat.h>

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif
#include <stdarg.h>
#include <syslog.h>

#include <netinet/in.h>

#define DYNARRAY(d, p, n, w) p = dynarray(d, p, n, w)
#define FREEDYNARRAY(d, p) p = freedynarray(d, p)

struct s2v {
	const char *s;
	int v;
};

struct v2v {
	int	v1;
	int	v2;
};

struct log {
	const char *fn;
	FILE *f;
	struct stat sbuf;
};

struct array {
	size_t osize;		/* object size (bytes) */
	size_t inclen;		/* optional incremental length when expanding */
	size_t len;		/* number of objects being used */
	size_t size;		/* number of objects currently allocated */
};

extern struct s2v syslog2str[];
extern struct log log_lf;

#ifdef __STDC__
struct aclgroup;
struct addr;
struct req;
#endif

extern socklen_t addr2sa(struct addr *, u_short, struct sockaddr *);
extern const char *addr2str(const struct addr *);
extern int blocking(int, int);
extern const char *checklimits(struct aclgroup *);
extern void checklog(struct log *);
extern const char *checkmaskwidth(const struct addr *);
extern void *dynarray(struct array *, void *, size_t, const char *);
extern const char *escapestr(const char *);
extern const char *extractaddr(const char *, const char *, struct addr *);
extern const char *extracthost(const char *, const char *, struct addr *);
extern void extracttimeval(struct timeval *, const char *);
extern int failed(const char *, const char *);
const char *family2protostr(int);
extern const char *fmtargv(int, char **);
extern void freeargv(char **);
extern void *freedynarray(struct array *, void *);
extern void getts(struct timeval *);
#ifndef HAVE_INET_ATON
#ifdef __STDC__
struct in_addr;
#endif
extern int inet_aton(const char *, struct in_addr *);
#endif
extern int insubnet(const struct addr *, const struct addr *);
extern int isdefaultaddr(struct addr *);
extern int isloopback(struct addr *);
extern void __attribute__ ((format (printf, 2, 3))) lg(int, const char *, ...);
extern int makeargv(const char *, char ***);
extern socklen_t mask2sa(struct addr *, u_short, struct sockaddr *);
extern int maskwidth(const struct addr *);
#ifdef __STDC__
struct client;
#endif
extern void nets_log(struct client *, struct req *);
extern void *new(size_t, size_t, const char *);
extern const char *pretty(const char *);
extern const char *readfile(const char *, const char *, int, void *,
    const char * (*)(const char *, const char *, void *));
extern void sa2addr(struct sockaddr *, struct sockaddr *, struct addr *,
    u_int16_t *);
extern void setmaskwidth(u_int, struct addr *);
extern int str2val(const struct s2v *, const char *);
#ifdef notdef
extern int str2valcase(const struct s2v *, const char *);
#endif
extern void strappend(char **, const char *);
extern const char *stripws(const char *);
#ifndef HAVE_STRLCPY
extern size_t strlcpy(char *, const char *, size_t);
#endif
extern char *strsave(const char *);
extern const char *tcporudpreqstr(int);
extern void trimws(char *, size_t);
extern const char *tsstr(void);
#ifdef notdef
extern int typ2flag(const struct v2v *, int);
#endif
extern const char *val2str(const struct s2v *, int);
extern const char *writefile(const char *, void *, void (*)(FILE *, void *));
#endif
